<?php
$pdo = new PDO("mysql:host=localhost;dbname=deltaweb_invoice;charset=utf8mb4", "deltaweb_invoice", "deltaweb_invoice");
$pdo->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);

function createInvoicePDF($invoice_no, $company, $items, $total, $currency="TL") {
    require_once(__DIR__ . '/../vendor/tcpdf/tcpdf.php');
    $pdf = new TCPDF();
    $pdf->SetFont('dejavusans', '', 12);
    $pdf->AddPage();

    $html = "<h2>فاتورة رقم: $invoice_no</h2>";
    $html .= "<b>ALICI ADI:</b> {$company['alici_adi']}<br>";
    $html .= "<b>ALICI ADRESI:</b> {$company['alici_adresi']}<br>";
    $html .= "<b>TESLIM ŞEKLİ:</b> {$company['teslim_sekli']}<br>";
    $html .= "<b>VERGİ DAİRESİ:</b> {$company['vergi_dairesi']}<br>";
    $html .= "<b>VERGİ NUMARASI:</b> {$company['vergi_numarasi']}<br><br>";

    $html .= "<table border='1' cellpadding='5'>
    <tr><th>المنتج</th><th>الكمية</th><th>السعر</th><th>الإجمالي</th></tr>";
    foreach ($items as $item) {
        $sub = $item['quantity'] * $item['price'];
        $html .= "<tr>
        <td>{$item['name']}</td>
        <td>{$item['quantity']}</td>
        <td>{$item['price']}</td>
        <td>$sub</td></tr>";
    }
    $html .= "</table><h3 style='text-align:right'>الإجمالي: $total $currency</h3>";

    $pdf->writeHTML($html);
    $path = __DIR__ . '/../pdf/invoices/';
    if (!file_exists($path)) mkdir($path, 0777, true);
    $file = $path . $invoice_no . ".pdf";
    $pdf->Output($file, 'F');
    return "pdf/invoices/" . $invoice_no . ".pdf";
}
?>
